<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build\Upgrade54To55;

use App\Domain\ModuleDomain;
use App\Domain\XCart;
use App\Entity\Module;
use App\Exception\ModuleDomainException;
use App\Marketplace\Marketplace;
use App\Marketplace\MarketplaceStorage;
use App\Repository\ModuleRepository;

final class GenerateTransitions
{
    private XCart $XCart;

    private ModuleRepository $moduleRepository;

    private ModuleDomain $moduleDomain;

    private MarketplaceStorage $marketplaceStorage;

    public function __construct(
        XCart $XCart,
        ModuleRepository $moduleRepository,
        ModuleDomain $moduleDomain,
        MarketplaceStorage $marketplaceStorage
    ) {
        $this->XCart              = $XCart;
        $this->moduleRepository   = $moduleRepository;
        $this->moduleDomain       = $moduleDomain;
        $this->marketplaceStorage = $marketplaceStorage;
    }

    /**
     * @throws \Exception
     */
    public function __invoke(): array
    {
        $transitions[Marketplace::CORE_MODULE_ID] = [
            'stateBefore'    => Module::STATE_ENABLED,
            'stateAfter'     => Module::STATE_ENABLED,
            'versionFrom'    => $this->marketplaceStorage->getValue('XCartCoreVersion'),
            'versionTo'      => $this->XCart->getCoreVersion(),
            'transitionType' => 'upgrade',
        ];

        foreach ($this->moduleRepository->getAllModules() as $module) {
            $moduleId    = $module->getModuleId();
            $moduleState = $module->getState();

            try {
                $versionTo = $this->moduleDomain->readModuleInfo($moduleId)['version'];
            } catch (ModuleDomainException $e) {
                continue;
            }

            $transitions[$moduleId] = [
                'stateBefore'    => $moduleState,
                'stateAfter'     => $moduleState,
                'versionFrom'    => $module->getVersion(),
                'versionTo'      => $versionTo,
                'transitionType' => 'upgrade',
            ];
        }

        return $transitions;
    }
}
