<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build\Upgrade54To55;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

final class CreateSession
{
    private string $tablePrefix;

    private EntityManagerInterface $entityManager;

    private SessionInterface $session;

    public function __construct(
        string $tablePrefix,
        EntityManagerInterface $entityManager,
        SessionInterface $session
    ) {
        $this->tablePrefix   = $tablePrefix;
        $this->entityManager = $entityManager;
        $this->session       = $session;
    }

    public function __invoke(string $login): void
    {
        if ($login) {
            $conn = $this->entityManager->getConnection();

            $profileId = $conn->fetchOne(
                "SELECT profile_id FROM {$this->tablePrefix}_profiles WHERE login = ?",
                [$login],
                [Types::STRING]
            );

            $this->session->set('profile_id', (int) $profileId);
        }
    }
}
