<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build\Upgrade;

use App\Domain\XCart;
use App\Entity\Module;
use App\Marketplace\Marketplace;
use App\Repository\ModuleRepository;

final class GenerateTransitions
{
    private XCart $XCart;

    private ModuleRepository $moduleRepository;

    public function __construct(
        XCart            $XCart,
        ModuleRepository $moduleRepository
    ) {
        $this->XCart            = $XCart;
        $this->moduleRepository = $moduleRepository;
    }

    public function __invoke(array $modulesToUpgrade): array
    {
        $transitions = [];

        foreach ($modulesToUpgrade as $moduleId => $upgrade) {
            if ($moduleId === Marketplace::CORE_MODULE_ID) {
                $moduleState   = Module::STATE_ENABLED;
                $versionFrom = $this->XCart->getCoreVersion();
            } else {
                $module        = $this->moduleRepository->findByModuleId($moduleId);
                $moduleState   = $module->getState();
                $versionFrom = $module->getVersion();
            }

            $transitions[$moduleId] = [
                'stateBefore'    => $moduleState,
                'stateAfter'     => $moduleState,
                'versionFrom'  => $versionFrom,
                'versionTo'   => Marketplace::implodeVersion($upgrade['version']),
                'transitionType' => 'upgrade',
            ];
        }

        return $transitions;
    }
}
