<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build;

use App\Exception\RebuildIsAlreadyStartedException;
use App\Repository\ScenarioRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Uid\UuidV4;

final class RemoveActiveScenario
{
    private RebuildFlag $rebuildFlag;

    private ScenarioRepository $scenarioRepository;

    private EntityManagerInterface $entityManager;

    public function __construct(
        RebuildFlag            $rebuildFlag,
        ScenarioRepository     $scenarioRepository,
        EntityManagerInterface $entityManager
    ) {
        $this->rebuildFlag        = $rebuildFlag;
        $this->scenarioRepository = $scenarioRepository;
        $this->entityManager      = $entityManager;
    }

    public function __invoke()
    {
        try {
            $this->rebuildFlag->check();
        } catch (RebuildIsAlreadyStartedException $e) {
            $id = new UuidV4($e->getScenarioId());

            $activeScenario = $this->scenarioRepository->findById($id);

            if ($activeScenario) {
                $this->entityManager->remove($activeScenario);
                $this->entityManager->flush();
            }

            $this->rebuildFlag->remove();
        }
    }
}
