<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build;

use App\Domain\XCart;
use App\Exception\RebuildIsAlreadyStartedException;

final class RebuildFlag
{
    public const REBUILD_FLAG_FILE_NAME = '.rebuildInProgress';

    private string $rebuildFlagPath;

    private BlockingFlag $blockingFlag;

    public function __construct(XCart $XCart, BlockingFlag $blockingFlag)
    {
        $this->rebuildFlagPath = $XCart->getSourcePath()
            . 'var/'
            . self::REBUILD_FLAG_FILE_NAME;

        $this->blockingFlag = $blockingFlag;
    }

    /**
     * @throws RebuildIsAlreadyStartedException
     */
    public function check(): void
    {
        if (file_exists($this->rebuildFlagPath)) {
            $scenarioId = file_get_contents($this->rebuildFlagPath);

            throw new RebuildIsAlreadyStartedException($scenarioId);
        }
    }

    public function create(string $scenarioId): void
    {
        file_put_contents($this->getRebuildFlagPath(), $scenarioId);
    }

    public function remove(): void
    {
        $rebuildFlagPath = $this->getRebuildFlagPath();

        if (file_exists($rebuildFlagPath)) {
            unlink($rebuildFlagPath);
        }

        $this->blockingFlag->remove();
    }

    public function getRebuildFlagPath(): string
    {
        return $this->rebuildFlagPath;
    }
}
