<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build;

use Symfony\Component\Filesystem\Filesystem;

final class PrepareFilesystem
{
    private Filesystem $filesystem;

    public function __construct(
        Filesystem $filesystem
    ) {
        $this->filesystem = $filesystem;
    }

    public function __invoke(array $files, array $dirs)
    {
        foreach ($dirs as $dir) {
            $this->filesystem->remove($dir);
            $this->filesystem->mkdir($dir);
        }

        foreach ($files as $file) {
            $this->filesystem->remove($file);
        }
    }
}
