<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build\InstallModules;

use App\Domain\XCart;
use CallbackFilterIterator;
use FilesystemIterator;
use RecursiveDirectoryIterator;
use RecursiveIteratorIterator;
use SplFileInfo;
use Symfony\Component\Filesystem\Filesystem;

final class MoveInstallPacks
{
    private string $sourcePath;

    private Filesystem $filesystem;

    public function __construct(
        XCart $XCart,
        Filesystem $filesystem
    ) {
        $this->sourcePath = $XCart->getSourcePath();
        $this->filesystem = $filesystem;
    }

    public function __invoke(array $packsToMove = []): void
    {
        foreach ($packsToMove as $packPath) {
            $this->filesystem->remove([
                "{$packPath}/.hash",
                "{$packPath}/.phar",
            ]);

            $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($packPath, FilesystemIterator::SKIP_DOTS), RecursiveIteratorIterator::SELF_FIRST);

            $iterator = new CallbackFilterIterator($iterator, function (SplFileInfo $current) {
                if (str_starts_with($current->getFilename(), '._')) {
                    return false;
                }

                return true;
            });

            $this->filesystem->mirror($packPath, $this->sourcePath, $iterator);
            $this->filesystem->remove($packPath);
        }
    }
}
