<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build;

use App\Operation\ExecuteShellCommand;
use Symfony\Component\Filesystem\Filesystem;

final class ExtractPack
{
    private ExecuteShellCommand $executeShellCommand;

    private Filesystem $filesystem;

    public function __construct(
        Filesystem          $filesystem,
        ExecuteShellCommand $executeShellCommand
    ) {
        $this->filesystem          = $filesystem;
        $this->executeShellCommand = $executeShellCommand;
    }

    public function __invoke(string $packPathWithoutExt): void
    {
        if ($this->filesystem->exists($packPathWithoutExt)) {
            $this->filesystem->remove($packPathWithoutExt);
        }

        $this->filesystem->mkdir($packPathWithoutExt);
        ($this->executeShellCommand)("tar -xzf {$packPathWithoutExt}.tar.gz -C {$packPathWithoutExt}");
        $this->filesystem->remove("{$packPathWithoutExt}.tar.gz");
    }
}
