<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build\Configuration;

use App\Domain\XCart;
use App\Repository\ModuleRepository;

final class GeneratePHPUnitConfiguration
{
    private XCart $XCart;

    private ModuleRepository $moduleRepository;

    public function __construct(
        XCart $XCart,
        ModuleRepository $moduleRepository
    ) {
        $this->XCart            = $XCart;
        $this->moduleRepository = $moduleRepository;
    }

    public function __invoke(): string
    {
        $modules = [];
        foreach ($this->moduleRepository->getSortedEnabledIds() as $moduleId) {
            [$author, $name] = explode('-', $moduleId);

            $path = "{$this->XCart->getModulesPath()}/{$author}/{$name}/tests";
            if (is_dir($path)) {
                $modules[] = "            <directory>modules/{$author}/{$name}/tests</directory>";
            }
        }

        $modules = implode("\n", $modules);

        return <<<"XML"
<?xml version="1.0" encoding="UTF-8"?>

<!-- https://phpunit.readthedocs.io/en/latest/configuration.html -->
<phpunit xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
         xsi:noNamespaceSchemaLocation="./vendor/phpunit/phpunit/phpunit.xsd"
         backupGlobals="false"
         colors="true"
         bootstrap="./tests/bootstrap.php"
         convertDeprecationsToExceptions="false"
>
    <php>
        <ini name="display_errors" value="1" />
        <ini name="error_reporting" value="-1" />
        <server name="APP_ENV" value="test" force="true" />
        <server name="SHELL_VERBOSITY" value="-1" />
        <server name="SYMFONY_PHPUNIT_REMOVE" value="" />
        <server name="SYMFONY_PHPUNIT_VERSION" value="9.5" />
        <server name="KERNEL_CLASS" value="\\XCart\\Kernel" />
    </php>

    <testsuites>
        <testsuite name="Project Test Suite">
            <directory>tests</directory>
{$modules}
        </testsuite>
    </testsuites>

    <coverage processUncoveredFiles="true">
        <include>
            <directory suffix=".php">src</directory>
        </include>
    </coverage>

    <listeners>
        <listener class="Symfony\\Bridge\\PhpUnit\\SymfonyTestsListener" />
    </listeners>

    <!-- Run `composer require symfony/panther` before enabling this extension -->
    <!--
    <extensions>
        <extension class="Symfony\\Component\\Panther\\ServerExtension" />
    </extensions>
    -->
</phpunit>
XML;
    }
}
