<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build\Configuration;

use App\Repository\ModuleRepository;

final class GenerateModules
{
    private ModuleRepository $moduleRepository;

    public function __construct(
        ModuleRepository $moduleRepository
    ) {
        $this->moduleRepository = $moduleRepository;
    }

    public function __invoke(): array
    {
        $modules = [];

        foreach ($this->moduleRepository->getAllModules() as $module) {
            $metadata = $module->getMetaData();
            $moduleId = $module->getModuleId();

            $modules[$moduleId] = [
                'id'               => $moduleId,
                'isEnabled'        => $module->isEnabled(),
                'type'             => $metadata['type'] ?? '',
                'author'           => $module->getAuthor() ?? '',
                'name'             => $module->getName() ?? '',
                'version'          => $module->getVersion(),
                'authorName'       => $metadata['authorName'] ?? '',
                'moduleName'       => $metadata['moduleName'] ?? '',
                'description'      => $metadata['description'] ?? '',
                'showSettingsForm' => $metadata['showSettingsForm'] ?? false,
                'canDisable'       => $metadata['canDisable'] ?? true,
                'dependsOn'        => $metadata['dependsOn'] ?? []
            ];
        }

        $activeSkinModuleId = $this->moduleRepository->getSortedEnabledSkinModuleIds()[0] ?? null;
        if ($activeSkinModuleId) {
            $modules[$activeSkinModuleId]['isActiveSkin'] = true;
        }

        return ['parameters' => ['xcart.modules' => $modules]];
    }
}
