<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build\Configuration;

use App\Domain\XCart;
use App\Repository\ModuleRepository;

final class GenerateDoctrineMappings
{
    private ModuleRepository $moduleRepository;

    private XCart $XCart;

    public function __construct(
        XCart $XCart,
        ModuleRepository $moduleRepository
    ) {
        $this->moduleRepository = $moduleRepository;
        $this->XCart = $XCart;
    }

    public function __invoke(): array
    {
        $mappings = [];

        foreach ($this->moduleRepository->getSortedEnabledIds() as $module) {
            [$author, $name] = explode('-', $module);

            // The directory is required to exist. It may exist in source code but miss in code cache because of dependency
            if (!is_dir( $this->XCart->getCodeCachePath() . "{$author}/{$name}/Model")) {
                continue;
            }

            $mappings["{$author}\\{$name}"] = [
                'is_bundle' => false,
                'type'      => 'annotation',
                'dir'       => "%kernel.project_dir%/var/run/classes/{$author}/{$name}/Model",
                'prefix'    => "{$author}\\{$name}\Model",
                'alias'     => "{$author}\\{$name}",
            ];
        }

        return ['doctrine' => ['orm' => ['mappings' => $mappings]]];
    }
}
