<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build\Configuration;

use App\Domain\XCart;
use App\Repository\ModuleRepository;

final class GenerateBundles
{
    private ModuleRepository $moduleRepository;

    private XCart $XCart;

    public function __construct(
        ModuleRepository $moduleRepository,
        XCart $XCart
    ) {
        $this->moduleRepository = $moduleRepository;
        $this->XCart = $XCart;
    }

    public function __invoke(): array
    {
        $bundles = [];

        foreach ($this->moduleRepository->getSortedEnabledIds() as $moduleId) {
            [$author, $name] = explode('-', $moduleId);

            $file = "{$this->XCart->getModulesPath()}/{$author}/{$name}/src/{$name}Bundle.php";

            if (file_exists($file)) {
                $class = "{$author}\\{$name}\\{$name}Bundle";
                $bundles[$class] = ['all' => true];
            }
        }

        return $bundles;
    }
}
