<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Operation\Build;

use App\Domain\XCart;

final class BlockingFlag
{
    public const FLAG_FILE_NAME = '.rebuildInBlockingState';

    private string $flagPath;

    public function __construct(XCart $XCart)
    {
        $this->flagPath = $XCart->getSourcePath()
            . 'var/'
            . self::FLAG_FILE_NAME;
    }

    public function remove(): void
    {
        if (file_exists($this->flagPath)) {
            unlink($this->flagPath);
        }
    }

    public function create(string $scenarioId): void
    {
        file_put_contents($this->getFlagPath(), $scenarioId);
    }

    public function getFlagPath(): string
    {
        return $this->flagPath;
    }
}
