<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Monolog\Handler;

use App\Domain\XCart;
use Monolog\Handler\StreamHandler;
use Monolog\Logger;

use function date;

class XCFileHandler extends StreamHandler
{
    const STREAM_FILE_NAME_SUFFIX = 'service-tool';

    private string $path;
    private string $file;
    private array $streams = [];

    public function __construct(XCart $XCart, string $file = '', int $level = Logger::DEBUG)
    {
        $this->path = $XCart->getSourcePath() . 'var/log/';
        $this->file = $file;

        parent::__construct($this->path, $level, true, 0644, false);
    }

    protected function write(array $record): void
    {
        if (empty($this->file)) {
            return;
        }

        $streamName = !empty($record['extra']['stream']) ? $record['extra']['stream'] : $this->file;

        $this->setStreamName($streamName);

        parent::write($record);

        $this->streams[$streamName]['url']    = $this->url;
        $this->streams[$streamName]['stream'] = $this->stream;
    }

    private function createFilePath(string $streamName): string
    {
        return $this->path . '/' . date('Y/m') . '/' . $streamName . '.' . date('Y-m-d') . '.' . self::STREAM_FILE_NAME_SUFFIX . '.log';
    }

    private function setStreamName($streamName): void
    {
        if (isset($this->streams[$streamName]['url'])) {
            $this->url    = $this->streams[$streamName]['url'];
            $this->stream = $this->streams[$streamName]['stream'] ?? null;
        } else {
            $this->url    = $this->createFilePath($streamName);
            $this->stream = null;
        }
    }
}
