<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace App\Monolog\Handler;

use Aws\CloudWatchLogs\CloudWatchLogsClient;
use Monolog\Logger;
use GuzzleHttp\Promise\PromiseInterface;

class CloudWatch extends \Maxbanton\Cwh\Handler\CloudWatch
{
    private bool $isConfigured;

    private PromiseInterface $promise;

    public function __construct(
        CloudWatchLogsClient $client,
        $group,
        $stream,
        $retention = 14,
        $batchSize = 10000,
        array $tags = [],
        $level = Logger::DEBUG,
        $bubble = true,
        $createGroup = true
    ) {
        parent::__construct(
            $client,
            $group,
            $stream,
            $retention,
            $batchSize,
            $tags,
            $level,
            $bubble,
            $createGroup
        );

        $this->promise = $client->getCredentials()->then(function ($credentials) {
            $this->isConfigured = empty($credentials->getAccessKeyId()) || empty($credentials->getSecretKey()) ? false : true;
        });
    }

    protected function write(array $record): void
    {
        $this->promise->then(function () use ($record) {
            if (!$this->isConfigured) {
                return;
            }

            parent::write($record);
        });
    }
}
