<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace App\Marketplace;

use App\Entity\Storage;
use Doctrine\ORM\EntityManagerInterface;

final class MarketplaceStorage
{
    private EntityManagerInterface $entityManager;
    private array $runtimeStorage;

    public function __construct(
        EntityManagerInterface $entityManager
    ) {
        $this->entityManager = $entityManager;
        $this->initStorage();
    }

    private function initStorage(): void
    {
        $allRecords = $this->entityManager->getRepository(Storage::class)->findAll();

        foreach ($allRecords as $record) {
            $this->runtimeStorage[$record->getKey()] = $record->getValue();
        }
    }

    public function getValue(string $key): ?string
    {
        return $this->runtimeStorage[$key] ?? null;
    }

    public function setValue(string $key, string $value): void
    {
        if (!isset($this->runtimeStorage[$key])) {
            $newItem = new Storage;
            $newItem->setKey($key);
            $newItem->setValue($value);
            $this->entityManager->persist($newItem);
            $this->runtimeStorage[$key] = $value;

        } else {
            if ($item = $this->entityManager->getRepository(Storage::class)->findOneByRecordKey($key)) {
                $item->setValue($value);
                $this->runtimeStorage[$key] = $value;
            }
        }

        $this->entityManager->flush();
    }

    public function removeValue(string $key): void
    {
        if ($item = $this->entityManager->getRepository(Storage::class)->findOneByRecordKey($key)) {
            unset($this->runtimeStorage[$key]);
            $this->entityManager->remove($item);
            $this->entityManager->flush();
        }
    }
}
