<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic\InstallRequirements;

final class XmlSupport implements XCartInterface
{
    public function getServiceName(): string
    {
        return 'xml_support';
    }

    public function getTitle(): string
    {
        return 'XML extensions support';
    }

    public function getLevel(): int
    {
        return static::LEVEL_OPTIONAL;
    }

    public function getState(bool $dataCheckerState): int
    {
        return $dataCheckerState ? static::STATE_SUCCESS : static::STATE_FAILURE;
    }

    public function getChecker(): array
    {
        $extensions = [];

        if (function_exists('xml_parse')) {
            $extensions[] = 'XML Parser';
        }

        if (function_exists('dom_import_simplexml')) {
            $extensions[] = 'DOM/XML';
        }

        return [
            (bool) count($extensions),
            'XML/Expat and DOM extensions are required for some modules.',
            ['%extensions%' => $extensions],
        ];
    }
}
