<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic\InstallRequirements;

interface XCartInterface
{
    public const LEVEL_CRITICAL = 8; // 0b1000;
    public const LEVEL_OPTIONAL = 1; // 0b0001;

    public const STATE_SUCCESS = 3; // 0b0011;
    public const STATE_FAILURE = 5; // 0b0101;

    public function getServiceName(): string;

    public function getTitle(): string;

    public function getLevel(): int;

    public function getState(bool $dataCheckerState): int;

    public function getChecker(): array;
}
