<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic\InstallRequirements;

final class SocketsSupport implements XCartInterface
{
    public function getServiceName(): string
    {
        return 'sockets_support';
    }

    public function getTitle(): string
    {
        return 'sockets extension';
    }

    public function getLevel(): int
    {
        return static::LEVEL_CRITICAL;
    }

    public function getState(bool $dataCheckerState): int
    {
        return $dataCheckerState ? static::STATE_SUCCESS : static::STATE_FAILURE;
    }

    public function getChecker(): array
    {
        return [
            extension_loaded('sockets'),
            'Required php extensions is not loaded: %extensions%',
            ['%extensions%' => 'sockets'],
        ];
    }
}
