<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic\InstallRequirements;

final class PhpUploadMaxFileSize implements XCartInterface
{
    public function getServiceName(): string
    {
        return 'php_upload_max_file_size';
    }

    public function getTitle(): string
    {
        return 'Upload file size limit';
    }

    public function getLevel(): int
    {
        return static::LEVEL_OPTIONAL;
    }

    public function getState(bool $dataCheckerState): int
    {
        return $dataCheckerState ? static::STATE_SUCCESS : static::STATE_FAILURE;
    }

    public function getChecker(): array
    {
        $value = @ini_get('upload_max_filesize');

        return [
            (bool) @ini_get('upload_max_filesize'),
            'PHP option upload_max_filesize must contain a value. It is currently empty.',
            ['%upload_max_filesize%' => $value],
        ];
    }
}
