<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic\InstallRequirements;

final class PhpPhar implements XCartInterface
{
    public function getServiceName(): string
    {
        return 'php_phar';
    }

    public function getTitle(): string
    {
        return 'Phar extension';
    }

    public function getLevel(): int
    {
        return static::LEVEL_OPTIONAL;
    }

    public function getState(bool $dataCheckerState): int
    {
        return $dataCheckerState ? static::STATE_SUCCESS : static::STATE_FAILURE;
    }

    public function getChecker(): array
    {
        return [
            extension_loaded('Phar'),
            'Phar extension must be installed.',
            [],
        ];
    }
}
