<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic\InstallRequirements;

final class PhpPdoMysql implements XCartInterface
{

    public function getServiceName(): string
    {
        return 'php_pdo_mysql';
    }

    public function getTitle(): string
    {
        return 'PDO extension';
    }

    public function getLevel(): int
    {
        return static::LEVEL_CRITICAL;
    }

    public function getState(bool $dataCheckerState): int
    {
        return $dataCheckerState ? static::STATE_SUCCESS : static::STATE_FAILURE;
    }

    public function getChecker(): array
    {
        return [
            class_exists('PDO') && defined('PDO::MYSQL_ATTR_LOCAL_INFILE'),
            'PDO extension with MySQL support must be installed.',
            [],
        ];
    }
}
