<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic\InstallRequirements;

final class PhpGdlib implements XCartInterface
{
    public function getServiceName(): string
    {
        return 'php_gdlib';
    }

    public function getTitle(): string
    {
        return 'GDlib extension';
    }

    public function getLevel(): int
    {
        return static::LEVEL_OPTIONAL;
    }

    public function getState(bool $dataCheckerState): int
    {
        return $dataCheckerState ? static::STATE_SUCCESS : static::STATE_FAILURE;
    }

    public function getChecker(): array
    {
        $result  = false;
        $version = '';

        if (extension_loaded('gd') && function_exists('gd_info')) {
            $gdInfo  = gd_info();
            $version = $gdInfo['GD Version'];
            $result  = preg_match('/\D*2\./', $gdInfo['GD Version']);
        }

        $imageCreateFromJPEG = function_exists('imagecreatefromjpeg');

        return [
            $result && $imageCreateFromJPEG,
            $imageCreateFromJPEG
                ? 'GDlib extension v.2.0 or later is required for some modules.'
                : 'GDlib extension does not have the JPEG plugin.',
            [
                '%version%'             => $version,
                '%imagecreatefromjpeg%' => $imageCreateFromJPEG,
            ],
        ];
    }
}
