<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic\InstallRequirements;

final class PhpFileUploads implements XCartInterface
{
    public function getServiceName(): string
    {
        return 'php_file_uploads';
    }

    public function getTitle(): string
    {
        return 'File uploads';
    }

    public function getLevel(): int
    {
        return static::LEVEL_OPTIONAL;
    }

    public function getState(bool $dataCheckerState): int
    {
        return $dataCheckerState ? static::STATE_SUCCESS : static::STATE_FAILURE;
    }

    public function getChecker(): array
    {
        $value = @ini_get('file_uploads');

        return [
            !in_array(strtolower($value), ['off', '0', '', false], true),
            'PHP file_uploads option must be set to On.',
            ['%file_uploads%' => $value],
        ];
    }
}
