<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic\InstallRequirements;

final class PhpDisabledFunctions implements XCartInterface
{
    private static function getRequiredFunctions(): array
    {
        return [
            'func_num_args', 'func_get_arg', 'func_get_args', 'strlen',
            'strcmp', 'strncmp', 'strcasecmp', 'strncasecmp',
            'error_reporting', 'define', 'defined',
            'get_class', 'get_called_class', 'get_parent_class', 'method_exists',
            'property_exists', 'class_exists', 'interface_exists', 'function_exists',
            'get_included_files', 'is_subclass_of', 'is_a', 'get_class_vars',
            'get_object_vars', 'set_error_handler', 'restore_error_handler', 'set_exception_handler',
            'get_declared_classes', 'get_resource_type', 'extension_loaded', 'debug_backtrace',
            'debug_print_backtrace', 'strtotime', 'date', 'gmdate',
            'mktime', 'strftime', 'time', 'getdate',
            'date_create', 'date_default_timezone_set', 'date_default_timezone_get',
            'preg_match', 'preg_match_all', 'preg_replace', 'preg_replace_callback',
            'preg_split', 'preg_quote', 'preg_grep', 'preg_last_error',
            'ctype_alpha', 'ctype_digit',
            'filter_var', 'filter_var_array', 'hash_hmac', 'json_encode',
            'json_decode',
            'spl_autoload_register', 'spl_autoload_unregister', 'spl_autoload_functions',
            'class_parents', 'class_implements', 'spl_object_hash', 'iterator_to_array',
            'simplexml_load_file', 'constant',
            'sleep', 'flush', 'htmlspecialchars', 'htmlentities',
            'html_entity_decode', 'get_html_translation_table', 'sha1', 'md5',
            'md5_file', 'crc32', 'getimagesize', 'phpinfo',
            'phpversion', 'substr_count', 'strspn', 'strcspn',
            'strtok', 'strtoupper', 'strtolower', 'strpos',
            'stripos', 'strrpos', 'strrev', 'nl2br',
            'basename', 'dirname', 'pathinfo', 'stripslashes',
            'stripcslashes', 'strstr', 'stristr', 'str_split',
            'substr', 'substr_replace', 'ucfirst', 'lcfirst',
            'ucwords', 'strtr', 'addslashes', 'addcslashes',
            'rtrim', 'str_replace', 'str_ireplace', 'str_repeat',
            'chunk_split', 'trim', 'ltrim', 'strip_tags',
            'explode', 'implode', 'join', 'setlocale',
            'chr', 'ord', 'parse_str', 'str_pad',
            'chop', 'sprintf', 'printf', 'sscanf',
            'parse_url', 'urlencode', 'urldecode', 'http_build_query',
            'unlink', 'exec', 'escapeshellcmd', 'escapeshellarg',
            'rand', 'srand', 'mt_rand', 'mt_srand',
            'getmypid', 'base64_encode', 'abs', 'ceil',
            'floor', 'round', 'is_infinite', 'pow',
            'log', 'sqrt', 'hexdec', 'octdec',
            'dechex', 'base_convert', 'number_format', 'getenv',
            'putenv', 'microtime', 'uniqid', 'quoted_printable_encode',
            'set_time_limit',
            'error_log', 'error_get_last', 'call_user_func', 'call_user_func_array',
            'serialize', 'unserialize', 'var_dump', 'var_export',
            'print_r', 'memory_get_usage', 'memory_get_peak_usage', 'register_shutdown_function',
            'ini_get', 'ini_set', 'get_include_path', 'set_include_path', 'setcookie',
            'header', 'headers_sent', 'parse_ini_file', 'is_uploaded_file',
            'move_uploaded_file', 'intval', 'floatval', 'doubleval',
            'strval', 'gettype', 'is_null', 'is_resource',
            'is_bool', 'is_float', 'is_int', 'is_integer',
            'is_numeric', 'is_string', 'is_array', 'is_object',
            'is_scalar', 'is_callable', 'pclose', 'popen',
            'readfile', 'rewind', 'rmdir', 'umask',
            'fclose', 'feof', 'fgets', 'fread',
            'fopen', 'fstat', 'fflush', 'fwrite',
            'fputs', 'mkdir', 'rename', 'copy',
            'tempnam', 'file', 'file_get_contents', 'file_put_contents',
            'stream_context_create', 'stream_context_set_params', 'stream_filter_append', 'stream_filter_remove',
            'stream_socket_enable_crypto', 'stream_get_contents', 'flock', 'stream_get_meta_data',
            'stream_set_timeout', 'socket_set_timeout', 'socket_get_status', 'realpath',
            'fsockopen', 'pack', 'unpack', 'opendir',
            'closedir', 'chdir', 'getcwd', 'readdir',
            'glob', 'filemtime', 'fileperms', 'filesize',
            'file_exists', 'is_writable', 'is_readable', 'is_executable',
            'is_file', 'is_dir', 'is_link', 'chmod',
            'touch', 'clearstatcache', 'disk_free_space', 'mail',
            'openlog', 'syslog', 'closelog', 'ob_start',
            'ob_flush', 'ob_clean', 'ob_end_clean', 'ob_get_clean',
            'ob_get_contents', 'ksort', 'krsort', 'asort',
            'sort', 'usort', 'uasort', 'uksort',
            'array_walk', 'array_walk_recursive', 'count', 'end',
            'next', 'reset', 'current', 'key',
            'min', 'max', 'in_array', 'array_search',
            'compact', 'array_fill', 'array_fill_keys', 'range',
            'array_multisort', 'array_push', 'array_pop', 'array_shift',
            'array_unshift', 'array_splice', 'array_slice', 'array_merge',
            'array_merge_recursive', 'array_replace_recursive', 'array_keys', 'array_values',
            'array_count_values', 'array_reverse', 'array_reduce', 'array_pad',
            'array_flip', 'array_change_key_case', 'array_unique', 'array_intersect',
            'array_intersect_key', 'array_diff', 'array_diff_key', 'array_diff_assoc',
            'array_udiff_assoc', 'array_sum', 'array_filter', 'array_map',
            'array_chunk', 'array_combine', 'array_key_exists', 'version_compare',
            'stream_get_filters', 'sys_get_temp_dir', 'token_get_all', 'xml_parser_create',
            'xml_parse_into_struct', 'xml_get_error_code', 'xml_error_string', 'xml_get_current_byte_index',
            'xml_parser_free',
        ];
    }

    public function getServiceName(): string
    {
        return 'php_disabled_functions';
    }

    public function getTitle(): string
    {
        return 'Disabled functions';
    }

    public function getLevel(): int
    {
        return static::LEVEL_OPTIONAL;
    }

    public function getState(bool $dataCheckerState): int
    {
        return $dataCheckerState ? static::STATE_SUCCESS : static::STATE_FAILURE;
    }

    public function getChecker(): array
    {
        $result = ['exists' => [], 'missed' => []];
        foreach (static::getRequiredFunctions() as $function) {
            $result[function_exists($function) ? 'exists' : 'missed'][] = $function;
        }

        if (count($result['missed'])) {
            $result['%missedFunctions%'] = substr(implode(', ', $result['missed']), 0, 45) . '...';
        }

        return [
            !(bool) count($result['missed']),
            'Disabled functions should be enabled',
            $result,
        ];
    }
}
