<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic\InstallRequirements;

final class MbstringSupport implements XCartInterface
{
    public function getServiceName(): string
    {
        return 'mbstring_support';
    }

    public function getTitle(): string
    {
        return 'mbstring extension';
    }

    public function getLevel(): int
    {
        return static::LEVEL_OPTIONAL;
    }

    public function getState(bool $dataCheckerState): int
    {
        return $dataCheckerState ? static::STATE_SUCCESS : static::STATE_FAILURE;
    }

    public function getChecker(): array
    {
        return [
            extension_loaded('mbstring'),
            'Recommended php extensions is not loaded: %extensions%',
            ['%extensions%' => 'mbstring'],
        ];
    }
}
