<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic\InstallRequirements;

final class IonCubePhpBug implements XCartInterface
{
    public function getServiceName(): string
    {
        return 'ioncube_php_bug';
    }

    public function getTitle(): string
    {
        return 'ioncube extension and php7.4';
    }

    public function getLevel(): int
    {
        return static::LEVEL_CRITICAL;
    }

    public function getState(bool $dataCheckerState): int
    {
        return $dataCheckerState ? static::STATE_SUCCESS : static::STATE_FAILURE;
    }

    public function getChecker(): array
    {
        return [
            !(PHP_VERSION_ID >= 70400 && PHP_VERSION_ID < 80000 && extension_loaded('ionCube Loader')),
            'Due to some bugs in the php 7.4 + ionCube bundle, installing may not be accomplished.',
        ];
    }
}
