<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic\InstallRequirements;

final class HttpsBouncer implements XCartInterface
{
    public function getServiceName(): string
    {
        return 'https_bouncer';
    }

    public function getTitle(): string
    {
        return 'HTTPS bouncers';
    }

    public function getLevel(): int
    {
        return static::LEVEL_OPTIONAL;
    }

    public function getState(bool $dataCheckerState): int
    {
        return $dataCheckerState ? static::STATE_SUCCESS : static::STATE_FAILURE;
    }

    public function getChecker(): array
    {
        $result  = false;
        $version = '';

        if (function_exists('curl_init') && function_exists('curl_version')) {
            $curlVersion = curl_version();

            if (is_array($curlVersion)) {
                $version = 'libcurl ' . $curlVersion['version'];
                if (!empty($curlVersion['ssl_version'])) {
                    $version .= ', ' . $curlVersion['ssl_version'];
                }
            } else {
                $version = $curlVersion;
            }

            $result = (!is_array($curlVersion) || in_array('https', $curlVersion['protocols'], true))
                && (is_array($curlVersion) || preg_match('/ssl|tls/Si', $curlVersion));
        }

        return [
            $result,
            $version
                ? 'libcurl extension is found but does not support secure protocols.'
                : 'libcurl extension not found.',
            ['%version%' => $version],
        ];
    }
}
