<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic\InstallRequirements;

final class EnvHostVarConfiguration implements XCartInterface
{
    protected string $httpHost;

    public function __construct($httpHost)
    {
        $this->httpHost = $httpHost;
    }

    public function getServiceName(): string
    {
        return 'http_host_options';
    }

    public function getTitle(): string
    {
        return 'HTTP connection';
    }

    public function getLevel(): int
    {
        return static::LEVEL_CRITICAL;
    }

    public function getState(bool $dataCheckerState): int
    {
        return $dataCheckerState ? static::STATE_SUCCESS : static::STATE_FAILURE;
    }

    public function getChecker(): array
    {
        $result = false;
        $errMsg = 'Curl is not installed or $this->httpHost cannot be resolved. Please check *HOST_DETAILS* configs in .env* files';

        if (
            function_exists('curl_init')
            && function_exists('curl_version')
            && ($host = $this->httpHost)
        ) {
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_RETURNTRANSFER => 1,
                CURLOPT_URL            => $host,
                CURLOPT_HEADER         => 1,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_SSL_VERIFYPEER => 0,
                CURLOPT_USERAGENT      => 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/999.99 (KHTML, like Gecko) Chrome/105.0.9999.99 Safari/999.99',
            ]);

            $resp = curl_exec($curl);

            if ($resp && preg_match('/\s*HTTP\/.*\s*(200|301|302)\b/', $resp, $matches)) {
                $result = true;
            } else {
                $statusCodeMsg = ($matches[0] ?? '') ? "Parsed status code $matches[0]." : '';
                $errMsg        = "Response from $this->httpHost is not 200|301|302. $statusCodeMsg curl_errno:" . curl_errno($curl) . ' curl_error:' . curl_error($curl)
                    . ". Make sure *HOST_DETAILS*  are correct in .env* files. Try to open $this->httpHost in a browser.";
            }

            curl_close($curl);
        }

        return [
            $result,
            $errMsg,
            [],
        ];
    }
}
