<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic\InstallRequirements;

/**
 * @package App\Logic
 */
final class DocBlocksSupport implements XCartInterface
{
    public function getServiceName(): string
    {
        return 'doc_blocks_support';
    }

    public function getTitle(): string
    {
        return 'DocBlocks support';
    }

    public function getLevel(): int
    {
        return static::LEVEL_CRITICAL;
    }

    public function getState(bool $dataCheckerState): int
    {
        return $dataCheckerState ? static::STATE_SUCCESS : static::STATE_FAILURE;
    }

    public function getChecker(): array
    {
        $rc           = new \ReflectionClass($this);
        $docBlock     = $rc->getDocComment();
        $eAccelerator = extension_loaded('eAccelerator');

        return [
            !empty($docBlock) && preg_match('/@package/', $docBlock),
            $eAccelerator
                ? 'The DocBlock feature is not supported by your PHP'
                : 'DocBlock feature being blocked may be the eAccelerator extension',
            ['%eAccelerator%' => $eAccelerator],
        ];
    }
}
