<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic\InstallRequirements;

use App\Domain\XCart;

final class ConfigFileName implements XCartInterface
{
    private string $rootPath;

    public function __construct(XCart $XCart)
    {
        $this->rootPath = $XCart->getSourcePath();
    }

    public function getServiceName(): string
    {
        return 'config_file';
    }

    public function getTitle(): string
    {
        return 'Config file';
    }

    public function getLevel(): int
    {
        return static::LEVEL_CRITICAL;
    }

    public function getState(bool $dataCheckerState): int
    {
        return $dataCheckerState ? static::STATE_SUCCESS : static::STATE_FAILURE;
    }

    public function getChecker(): array
    {
        $configFileName        = '.env.local';
        $defaultConfigFileName = '.env';
        $configPath            = $this->rootPath;

        return [
            @is_readable($configPath . $configFileName),
            'Config file does not exist',
            [
                '%configPath%'            => $configPath,
                '%configFileName%'        => $configFileName,
                '%defaultConfigFileName%' => $defaultConfigFileName,
            ],
        ];

    }
}
