<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic;

use App\Logic\InstallRequirements\XCartInterface;

final class GetInstallRequirements
{
    /**
     * @var iterable|XCartInterface[]
     */
    private iterable $requirements;

    public function __construct(iterable $requirements)
    {
        $this->requirements = $requirements;
    }

    public function getResult(): array
    {
        $result = [];

        foreach ($this->requirements as $requirementObj) {
            $checkerData = $requirementObj->getChecker();

            $data = [
                'title'         => $requirementObj->getTitle(),
                'label_message' => $requirementObj->getServiceName() . '.label_message',
                'kb_message'    => $requirementObj->getServiceName() . '.kb_message',
                'level'         => $requirementObj->getLevel(),
                'state'         => $requirementObj->getState($checkerData[0] ?? false),
                'description'   => $checkerData[1] ?: $requirementObj->getServiceName(),
                'data'          => $checkerData[2] ?? [],
            ];

            $result[$requirementObj->getServiceName()] = $data;
        }

        return $result;
    }
}
