<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Logic;

use MJS\TopSort\CircularDependencyException;
use MJS\TopSort\ElementNotFoundException;
use MJS\TopSort\TopSortInterface;

final class CheckDependencyMap
{
    private TopSortInterface $sorter;

    public function __construct(
        TopSortInterface $sorter
    ) {
        $this->sorter = $sorter;
    }

    /**
     * @param array $map Dependency map format: [ModuleId => [ModuleId, ModuleId, ...], ...]
     *
     * @return array Empty result means no cycles in dependency map
     */
    public function getCycle(array $map): array
    {
        foreach ($map as $item => $dependencies) {
            foreach ($dependencies as $dependency) {
                // On this stage we need to find a cycles, so we add nodes without dependencies too
                if (!isset($map[$dependency])) {
                    $this->sorter->add($dependency);
                }
            }

            $this->sorter->add($item, $dependencies);
        }

        try {
            $this->sorter->sort();
        } catch (CircularDependencyException $e) {
            return $e->getNodes();
        } catch (ElementNotFoundException $e) {
            // Do nothing here because we prevented this case when items have been added
        }

        return [];
    }

    public function sort(array $map): array
    {
        foreach ($map as $item => $dependencies) {
            foreach ($dependencies as $key => $dependency) {
                if (!isset($map[$dependency])) {
                    unset($dependencies[$key]);
                }
            }

            $this->sorter->add($item, $dependencies);
        }

        return $this->sorter->sort();
    }
}
