<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\LifetimeHook\Upgrade;

use Doctrine\ORM\EntityManagerInterface;

final class UpgradeTo550build6
{
    private EntityManagerInterface $entityManager;

    public function __construct(
        EntityManagerInterface $entityManager
    ) {
        $this->entityManager = $entityManager;
    }

    public function onUpgrade(): void
    {
        $adminEmailDataEntries = $this->entityManager->getRepository('App\Entity\Data')->findBy([
            'name' => 'xcart.marketplace.admin-email'
        ]);
        $adminShopCountryDataEntries = $this->entityManager->getRepository('App\Entity\Data')->findBy([
            'name' => 'xcart.marketplace.shop-country'
        ]);
        $entitiesToRemove = array_merge(
            array_splice($adminEmailDataEntries, 1),
            array_splice($adminShopCountryDataEntries, 1)
        );

        foreach ($entitiesToRemove as $entity) {
            $this->entityManager->remove($entity);
        }

        $this->entityManager->flush();
    }
}
