<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\LifetimeHook\Upgrade;

use Doctrine\DBAL\Schema\Column;
use Doctrine\DBAL\Schema\TableDiff;
use Doctrine\DBAL\Types\BooleanType;
use Doctrine\ORM\EntityManagerInterface;

final class UpgradeTo550build3
{
    private EntityManagerInterface $entityManager;

    public function __construct(
        EntityManagerInterface $entityManager
    ) {
        $this->entityManager = $entityManager;
    }

    public function onUpgrade(): void
    {
        $connection = $this->entityManager->getConnection();
        $manager = $connection->getSchemaManager();

        if ($manager) {
            $table = $manager->listTableDetails('service_module');

            if (!$table->hasColumn('has_local_files')) {
                $tableDiff = new TableDiff('service_module');
                $tableDiff->addedColumns[] = new Column(
                    'has_local_files',
                    new BooleanType(),
                    [
                        'default' => 1
                    ]
                );

                $manager->alterTable($tableDiff);
            }
        }
    }
}
