<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\LifetimeHook\Upgrade;

use App\Domain\XCart;
use App\Entity\Scenario;
use App\Repository\ScenarioRepository;
use Symfony\Component\Filesystem\Filesystem;

final class UpgradeTo550build2
{
    private Filesystem $filesystem;

    private ScenarioRepository $scenarioRepository;

    private string $sourcePath;

    public function __construct(
        XCart $XCart,
        Filesystem $filesystem,
        ScenarioRepository $scenarioRepository
    ) {
        $this->filesystem         = $filesystem;
        $this->scenarioRepository = $scenarioRepository;
        $this->sourcePath         = $XCart->getSourcePath();
    }

    public function onUpgrade(): void
    {
        $upgradeEntries = $this->getScenario()->getMetaData()['upgradeEntries'] ?? [];

        foreach ($upgradeEntries as $moduleUpgradeEntries) {
            foreach ($moduleUpgradeEntries as $upgradeEntry) {
                $filepath       = $upgradeEntry['filepath'];
                $targetFilePath = "{$this->sourcePath}{$filepath}";

                if ($upgradeEntry['type'] === 'added') { // the file does not exist in the new version of the module
                    $this->filesystem->remove($targetFilePath);
                }
            }
        }
    }

    protected function getScenario(): Scenario
    {
        /** @var Scenario $scenario */
        $scenario = $this->scenarioRepository->findLastScenario();

        return $scenario;
    }
}
