<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\LifetimeHook\Upgrade;

use App\Operation\Build\BlockingFlag;

final class UpgradeTo550build15
{
    private BlockingFlag $blockingFlag;

    public function __construct(
        BlockingFlag $blockingFlag
    ) {
        $this->blockingFlag = $blockingFlag;
    }

    public function onUpgrade(): void
    {
        // In this version blocking flag changed from .rebuildInProgress to .rebuildInBlockingState
        // but .rebuildInBlockingState was not created because upgrade starts on the old codebase
        $this->blockingFlag->create('upgrade');
    }
}
