<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\LifetimeHook\Upgrade;

use Doctrine\DBAL\Schema\Column;
use Doctrine\DBAL\Schema\ColumnDiff;
use Doctrine\DBAL\Schema\TableDiff;
use Doctrine\DBAL\Types\StringType;
use Doctrine\ORM\EntityManagerInterface;

final class UpgradeTo550build13
{
    private EntityManagerInterface $entityManager;

    public function __construct(
        EntityManagerInterface $entityManager
    ) {
        $this->entityManager = $entityManager;
    }

    public function onUpgrade(): void
    {
        $schemaManager = $this->entityManager->getConnection()->getSchemaManager();
        $tableDiff = new TableDiff('service_module');
        $tableDiff->changedColumns[] = new ColumnDiff(
            'name',
            new Column('name', new StringType(), ['notnull' => true, 'length' => 128])
        );
        $tableDiff->changedColumns[] = new ColumnDiff(
            'module_id',
            new Column('module_id', new StringType(), ['notnull' => true, 'length' => 255])
        );

        $schemaManager->alterTable($tableDiff);
    }
}
