<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Exception;

use Exception;

final class UpgradeException extends Exception
{
    public static function fromWrongUpgradeType(): self
    {
        return new self('Incorrect upgrade type. Available types: build, minor, major');
    }

    public static function fromNoUpgradesForType($type): self
    {
        return new self("No {$type} upgrades");
    }

    public static function fromNoUpgrades(): self
    {
        return new self("No upgrades");
    }
}
