<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Exception;

use Exception;

final class RemoveModulesException extends Exception
{
    public static function fromAlreadyRemovedModule(string $moduleId): self
    {
        return new self("Module {$moduleId} already removed");
    }
}
