<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Exception;

use Exception;

final class RebuildIsAlreadyStartedException extends Exception
{
    private string $scenarioId;

    public function __construct(string $scenarioId)
    {
        parent::__construct('Rebuild is already started.');

        $this->setScenarioId($scenarioId);
    }

    /**
     * @return string
     */
    public function getScenarioId(): string
    {
        return $this->scenarioId;
    }

    /**
     * @param string $scenarioId
     */
    public function setScenarioId(string $scenarioId): void
    {
        $this->scenarioId = $scenarioId;
    }
}
