<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Exception;

use Exception;

final class ModuleDomainException extends Exception
{
    public static function fromIncorrectModuleIdFormat(string $module): self
    {
        return new self("'{$module}' has incorrect format. Use [Author]-[Name] format for moduleId");
    }

    public static function fromNoConfigFile(string $configPath): self
    {
        return new self("Addon config file not found in {$configPath}");
    }
}
