<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Exception;

use Exception;

final class HookManagerException extends Exception
{
    public static function fromRunHook(Exception $e, string $hookType): self
    {
        $message = "Error in runHook method (hookType: {$hookType})\n"
            . $e->getMessage();

        return new self($message, $e->getCode(), $e);
    }
}
