<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Exception;

use Exception;

class GetTokenDataException extends Exception
{
    public static function fromResponseWithError(string $error): self
    {
        return new self("get_token_data error: {$error}");
    }

    public static function fromEmptyResponse(): self
    {
        return new self('Licenses by token are not found');
    }
}
