<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Exception;

use Exception;

final class GetHashException extends Exception
{
    public static function fromGetCoreHashResponseWithError(string $error): self
    {
        return new self("get_core_hash error: {$error}");
    }

    public static function fromGetModuleHashResponseWithError(string $error): self
    {
        return new self("get_addon_hash_batch error: {$error}");
    }

    public static function fromGetAddonHashBatchResponseWithError(string $moduleId, string $error): self
    {
        return new self("get_addon_hash_batch error for {$moduleId} addon: {$error}");
    }
}
