<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Exception;

use Exception;

final class DownloadPacksException extends Exception
{
    public static function fromResponseWithError(string $error): self
    {
        return new self("Package download error: {$error}");
    }

    public static function fromEmptyResponse(): self
    {
        return new self('Package download error: empty response');
    }

    public static function fromIncorrectModuleData(string $moduleId): self
    {
        return new self("Download failed for module {$moduleId}");
    }

    public static function fromAlreadyInstalledModule(string $moduleId): self
    {
        return new self("Module {$moduleId} already installed");
    }
}
