<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Exception;

use Exception;

class DownloadPackException extends Exception
{
    public static function fromResponseWithError(string $error, string $moduleId): self
    {
        return new self("Package download error: {$error} (moduleId: {$moduleId})");
    }

    public static function fromEmptyResponse(string $moduleId): self
    {
        return new self("Package download error: empty response (moduleId: {$moduleId})");
    }
}
