<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Exception;

use App\Exception\DownloadPackException;

final class DownloadModulesException extends DownloadPackException
{
    public static function fromUnknownModule(string $moduleId): self
    {
        return new self("Module {$moduleId} was not found in Marketplace");
    }

    public static function fromAlreadyInstalledModule(string $moduleId): self
    {
        return new self("Module {$moduleId} already installed");
    }

    public static function fromNotActualVersionModules(array $moduleIds): self
    {
        return new self(sprintf("Modules %s not have actual versions", implode(', ', $moduleIds)));
    }
}
