<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Exception;

use Exception;

final class ConfigurationException extends Exception
{
    public static function fromMissingOption(string $name): self
    {
        return new self(sprintf('The configuration variable "%s" is not defined', $name));
    }

    public static function fromWrongValue(string $name, string $value): self
    {
        return new self(sprintf('The configuration variable "%s" has a wrong value: %s', $name, $value));
    }

    public static function fromMissingModulesPath(string $path): self
    {
        return new self(sprintf('The modules path does not exists: %s', $path));
    }
}
