<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Exception;

use Exception;

final class CircularDependencyException extends Exception
{
    private array $cycle = [];

    public static function fromDependenciesCheck(array $cycle): self
    {
        $exception = new self('Cycle found in dependencies ' . implode('->', $cycle));
        $exception->setCycle($cycle);

        return $exception;
    }

    public static function fromIncompatiblesCheck(array $cycle): self
    {
        $exception = new self('Cycle found in incompatibles ' . implode('->', $cycle));
        $exception->setCycle($cycle);

        return $exception;
    }

    public function getCycle(): array
    {
        return $this->cycle;
    }

    public function setCycle(array $cycle): void
    {
        $this->cycle = $cycle;
    }
}
